unit IBMChars;

interface

uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
     BMisc,
     BConfig;

Type TMapString=String[64];

// Standard character set
//     0 1 2 3 4 5 6 7 8 9 A B C D E F
//  0    1 2 3 4 5 6 7 8 9 0 # @ : > t
//  1  b / S T U V W X Y Z r , % ~ \ p
//  2  - J K L M N O P Q R ! $ * ] ; d
//  3  a A B C D E F G H I q . o [ < g

Const MapChrs: String=
  ' 1234567890#@:>tb/STUVWXYZr,%~\p-JKLMNOPQR!$*];daABCDEFGHIq.o[<g';

Type
  TCharMapForm = class(TForm)
    Panel1:    TPanel;
    LBCharMap: TListBox;
  private
//  function  BuildUsageMatrix(PN: String): TCharMap;
//  procedure DisplayNonStdUsage(PN: String; CM: TCharMap);
//  procedure DisplayUsageMap(CM: TCharMap);
//  procedure DisplayUsageNotes;
    MapID:    Char;
    function  GetFileMapID(PN: String): Char;
    function  LoadMappingString(MN: Char): TMapString;
    procedure MapAndLoad(PN: String; MS: TMapString; SL: TStringList);
  public
    procedure ProcessCardFile(PN: String; SL: TStringList);
  end;

Var CharMapForm: TCharMapForm;

implementation

{$R *.DFM}

procedure TCharMapForm.ProcessCardFile(PN: String; SL: TStringList);
Var MS: TMapString;
//  CM: TCharMap;
begin
//CM:=BuildUsageMatrix(PN);
//DisplayUsageMap(CM);
//DisplayNonStdUsage(PN,CM);
//DisplayUsageNotes;
  MapID:=GetFileMapID(PN);
  MS:=LoadMappingString(MapID);
  MapAndLoad(PN,MS,SL);
end;

Function TCharMapForm.GetFileMapID(PN: String): Char;
Var CF: TextFile;
    CN,CS: String;
Begin
  Result:='0';
  CN:=EXEPath+'B1401.CFM';
  If Not FileExists(CN) then
    Raise Exception.Create('Card input mapping control file: '+CN+' does not exist');
  AssignFile(CF,CN); Reset(CF);
  PN:=UpperCase(DelExt(ExtractFileName(PN)));
  While Not EOF(CF) do begin
    Readln(CF,CS);
    If CS[1]='*' then Continue;
    If CS[1]=';' then Continue;
    If UpperCase(Copy(CS,1,5))='MAPID' then begin
      Result:=CS[6]; Continue;
    End;
    If UpperCase(CS)=PN then Break
  End;
  CloseFile(CF);
End;

Function TCharMapForm.LoadMappingString(MN: Char): TMapString;
Var MF: TextFile;
    PN: String;
    CS: String;
    TS: TMapString;
    CI: Integer;
    TC: Char;
Begin
  // Use Mapping from this file regardless... (for now)
  PN:=EXEPath+'CardMap'+MN+'.CCM';
  If Not FileExists(PN) then
    Raise Exception.Create('Card input mapping file: '+PN+' does not exist');
  AssignFile(MF,PN); Reset(MF);
  Repeat
    Readln(MF,TS);
  Until EOF(MF);
  CloseFile(MF);
  While Length(TS)<64 do TS:=TS+' ';
  CS:=StringOfChar(#0,256);
  For CI:=1 to 64 do begin
    TC:=TS[CI];
    If (TC<>' ') And (CS[Ord(TC)]<>#0) then
      Raise Exception.Create('Duplicate character: "'+TC+'" ('+
                             IntToHex(Ord(TC),2)+') in mapping file: '+PN);
    CS[Ord(TC)]:=#1;
  End;
  Result:=TS;
End;

Procedure TCharMapForm.MapAndLoad(PN: String; MS: TMapString; SL: TStringList);
Var CI: Byte;
    OS,RS: String;
    CF: TextFile;
    CN: Integer;
    CC: Char;
    OC: Byte;
Begin
  AssignFile(CF,PN); Reset(CF); CN:=0;
  While Not Eof(CF) do begin
    Readln(CF,OS); While Length(OS)<80 do OS:=OS+' ';
    RS:=OS; Inc(CN);
    For CI:=1 to Length(OS) do begin
      CC:=OS[CI]; OC:=Pos(CC,MS);
      If OC=0 then
        Raise Exception.Create('Unmapped character in file: '+PN+#$D+
                               '"'+CC+'" ($'+IntToHex(Ord(CC),2)+
                               ') at column '+IntToStr(CI)+
                               ' of card '+IntToStr(CN)+#$D+
                               'Card in error (original):-'+#$D+OS+#$D+
                               'Partially translated:-'+#$D+RS+#$D+
                               'Mapping file ID='+MapID);
      RS[CI]:=MapChrs[OC];
    End;
    SL.Add(RS);
  End;
  CloseFile(CF);
End;

(*
  If CV=' '  then CV:=#0;      // Translate ' ' to #0
  If CV=#$D8 then CV:='?';     // Translate #$D8 to '?'
  If CV=':'  then CV:='#';     // Translate ':' to '#'
  If CV='('  then CV:='%';     // Translate '(' to '%'
  If CV='('  then CV:='%';     // Translate ')' to '%'
  If CV=')'  then CV:=#$7F;    // Translate ')' to '%'
*)
(*
Function TCharMapForm.BuildUsageMatrix(PN: String): TCharMap;
Var CF: TextFile;
    CD: String;
    CI: Integer;
    CC: Char;
begin
  FillChar(Result,SizeOf(Result),#0);
  AssignFile(CF,PN); Reset(CF);
  While Not Eof(CF) do begin
    Readln(CF,CD);
    For CI:=1 to Length(CD) do begin
      CC:=CD[CI];
      Inc(Result[Ord(CC)]);
    End;
  End;
  CloseFile(CF);
End;

// Display character count matrix
Procedure TCharMapForm.DisplayUsageMap(CM: TCharMap);
Var RI,CI: Byte;
    HS,SS: String;
Begin
  With CharMapForm.LBCharMap do begin
    Clear;
    HS:='   ';
    For RI:=0 to $F do begin
      SS:=' '+IntToHex(RI,2);
      For CI:=0 to $F do begin
        If RI=0 then  HS:=HS+'   '+IntToHex(CI,2);
        SS:=SS+' '+LPad(IntToStr(CM[(RI Shl 4)+CI]),4);
      End;
      If RI=0 then Items.Add(HS);
      Items.Add(SS);
    End;
  End;
End;

// Display non standard character usage, Write to log file
Procedure TCharMapForm.DisplayNonStdUsage(PN: String; CM: TCharMap);
Var RI: Byte;
    SS: String;
    MF: TextFile;
Begin
  With CharMapForm.LBCharMap do begin
    SS:=EXEPath+'CHARUSE.LOG';
    If FileExists(SS) then begin
      AssignFile(MF,SS); Append(MF);
    End else Begin
      AssignFile(MF,SS); Rewrite(MF);
    End;
    WriteLn(MF,PN);
    For RI:=0 to $FF do begin
      If CM[RI]=0 then Continue;
      If Pos(Chr(RI),StdChrs)>0 then Continue;
      SS:=' $'+IntToHex(RI,2)+' '+Chr(RI)+'  '+IntToStr(CM[RI]);
      Items.Add(SS);
      WriteLn(MF,SS);
    End;
    CloseFile(MF);
  End;
End;

// Display usage notes
Procedure TCharMapForm.DisplayUsageNotes;
Begin
  With CharMapForm.LBCharMap do begin
    Items.Add(' HX   BS   BA   PO   NC    A    F    P');
    Items.Add(' 0B   #    #    =    =#    #    =    #=');
    Items.Add(' 0C   @    @    ''    ''@    @    ''    @''');
    Items.Add(' 0D   :    :    :    :               :');
    Items.Add(' 0E   >    >    >    >               >');
    Items.Add(' 0F   (    t        FB          {    {     (Tape Mark)');
    Items.Add(' 10   ^    c         b          ^    ^     (Cents or b with a stroke)');
    Items.Add(' 1A   ''    r         |          |    |     (Record Mark)');
    Items.Add(' 1C   %    %    (    %(    %    (    %(');
    Items.Add(' 1D   =    =         ^               ~');
    Items.Add(' 1E   \    ''    \    \               \');
    Items.Add(' 2A   !    !    !    !     -    -    !');
    Items.Add(' 2D   ]    )    ]    ]               ]');
    Items.Add(' 2E   ;    ;    ;    ;               ;');
    Items.Add(' 2F   _    d        7F               _     (Delta)');
    Items.Add(' 30   &    &    +    +&    &    &    &+');
    Items.Add(' 3A   ?    ?    ?    ?     &    &    ?');
    Items.Add(' 3C   )    o    )    )     )    )    )     (Lozenge)');
    Items.Add(' 3D   [    (    [    [               [');
    Items.Add(' 3E   <    <    <    <               <');
    Items.Add(' 3F   *    "    g         CE         }     (Group Mark)');
  End;
End;
*)
Initialization
  If Length(MapChrs)<>64 then Exception.Create('Bad mapchars length');
end.

