unit IBM1403;

interface

uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs, ExtCtrls, URecDisp, StdCtrls, ComCtrls;

type
  TPrinterForm = class(TForm)
    Panel1: TPanel;
    LALineCount: TLabel;
    Label1: TLabel;
    Printer: TUnitRecordDisplay;
    CBSize: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure CBSizeClick(Sender: TObject);
  private
  public
    procedure Clear;
    procedure SaveOutput(PN: String);
    procedure PrintLine(PL: TLine);
    Function  LineCount: Word;
  end;

var PrinterForm: TPrinterForm;

implementation

{$R *.DFM}

procedure TPrinterForm.FormShow(Sender: TObject);
begin
  Caption:='IBM Emulator - 1403 Printer';
end;

procedure TPrinterForm.FormResize(Sender: TObject);
begin
  Printer.Width:=Width;  // Force recalc
end;

procedure TPrinterForm.CBSizeClick(Sender: TObject);
begin
  If Not CBSize.Checked then Printer.Font.Size:=6
                        else Printer.Font.Size:=8;
end;

procedure TPrinterForm.Clear;
begin
  Printer.Clear;
end;

procedure TPrinterForm.SaveOutput(PN: String);
begin
  Printer.SaveRecords(PN);
end;

function TPrinterForm.LineCount: Word;
begin
  Result:=Printer.Count;
end;

Procedure TPrinterForm.PrintLine(PL: TLine);
begin
  Printer.PrintLine(PL);
  LALineCount.Caption:=IntToStr(Printer.Count);
end;

end.
