unit HOLMain;

interface

uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs, StdCtrls;

type
  TMainForm = class(TForm)
    LBLog: TListBox;
    procedure FormShow(Sender: TObject);
  private
    function Combine(ZS, NS: String): String;
    procedure Convert(DN: String);
    function ConvSpec(HB: String): String;
  public
  end;

var MainForm: TMainForm;

implementation

{$R *.DFM}

// Hollerith card codes
// ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 #&*,./<-%()\@
// CCCCCCCCCDDDDDDDDDEEEEEEEEFFFFFFFFFF4755646466CDE7
// 1234567891234567892345678901234567890B0CBB1C0C000C

//  Bert Standard set
//     0 1 2 3 4 5 6 7 8 9 A B C D E F
//  0    1 2 3 4 5 6 7 8 9 0 # @ : > (
//  1  ^ / S T U V W X Y Z ' , % = \ +
//  2  - J K L M N O P Q R ! $ * ] ; d
//  3  & A B C D E F G H I ? . ) [ < g

Const MapChrs: String=' 1234567890#@:>(^/STUVWXYZ'',%=\+-JKLMNOPQR!$*];d&ABCDEFGHI?.)[<g';

procedure TMainForm.FormShow(Sender: TObject);
begin
  Convert('SPS2-1');
  Convert('SPS2-2');
  Convert('SPS2-3');
  Convert('SPS2-4');
  Convert('SPS2-5');
end;

Procedure TMainForm.Convert(DN: String);
Var HF,CF: TextFile;
    ZS,NS: String;
    II: Byte;
Begin
  LBLog.Items.Add('Processing '+DN);
  // Open files
  AssignFile(HF,DN+'.HCP'); Reset(HF);
  AssignFile(CF,DN+'.CRD'); Rewrite(CF);
  // Process Hollerith Card Pictures
  Repeat
    ReadLn(HF,ZS);      // Skip legend
    ReadLn(HF,ZS);      // Skip ascii
    ReadLn(HF,ZS);      // Get Zones
    ReadLn(HF,NS);      // Get Numerics
    ZS:=Combine(ZS,NS); // Combine and Translate
    WriteLn(CF,ZS);     // Output result
    For II:=1 to 12 do  // Skip picture
      ReadLn(HF,ZS);
  Until Eof(HF);        // All done?
  // Close files
  CloseFile(CF);
  CloseFile(HF);
  LBLog.Items.Add('Done');
End;

Function TMainForm.Combine(ZS,NS: String): String;
Var II: Byte;
    HB: String[2];
    BB: Byte;
    CC: Char;
Begin
  Result:='';
  For II:=1 to 80 do begin
    HB:=ZS[II]+NS[II];            // Form hex string
    // Convert zone char into 0-3
    If HB[2]<>'0' then            // Alpha numerics except "0"
      Case HB[1] of
        'C': HB[1]:='3';
        'D': HB[1]:='2';
        'E': HB[1]:='1';
        'F': HB[1]:='0';
        Else HB:=ConvSpec(HB);    // Weird chars
      End
    Else
      HB:=ConvSpec(HB);           // Weird chars
    BB:=StrtoInt('$'+HB);         // Convert to binary
    CC:=MapChrs[BB+1];            // Convert to ASCII
    Result:=Result+CC;            // Build result string
  End;
End;

Function TMainForm.ConvSpec(HB: String): String;
Begin
  Result:='';
  If HB='40' then Result:='00'; // blank
  If HB='7B' then Result:='0B'; // #
  If HB='50' then Result:='30'; // &
  If HB='5C' then Result:='2C'; // *
  If HB='6B' then Result:='1B'; // ,
  If HB='4B' then Result:='3B'; // .
  If HB='61' then Result:='11'; // /
  If HB='4C' then Result:='3C'; // < change to ) 
  If HB='60' then Result:='20'; // -
  If HB='6C' then Result:='1C'; // %
  If HB='C0' then Result:='1C'; // ( change to %
  If HB='D0' then Result:='2C'; // )
  If HB='E0' then Result:='1E'; // \
  If HB='F0' then Result:='0A'; // 0
  If HB='7C' then Result:='0C'; // @
  If Result='' then LBLog.Items.Add('Bad code: '+HB);
End;

end.
