unit B1401CORE;

interface

uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Forms, Dialogs, ComCtrls, StdCtrls,
     B1401COR,
     B1401CNV;

type
  TCoreForm = class(TForm)
    LAChar: TLabel;
    LAMark: TLabel;
    LALegd: TLabel;
    LABase: TLabel;
    UDBase: TUpDown;
    procedure FormShow(Sender: TObject);
    procedure UDBaseClick(Sender: TObject; Button: TUDBtnType);
  private
    procedure ShowLegend;
  public
    procedure Clear;
    procedure ShowCore;
  end;

var CoreForm: TCoreForm;
    DispBase: Integer;

implementation

{$R *.DFM}

procedure TCoreForm.FormShow(Sender: TObject);
begin
  ShowLegend;
end;

procedure TCoreForm.ShowLegend;
Var LC: Word;
    LS: String;
begin
  LS:=StringOfChar('.',100);
  For LC:=1 to 19 do begin
    LS[LC*5+1]:='^';
  End;
  For LC:=0 to 9 do begin
    LS[LC*10+1]:=Chr(LC+$30);
    LS[LC*10+2]:='0';
  End;
  LS[2]:='1';
  LALegd.Caption:=LS;
End;

procedure TCoreForm.ShowCore;
Var AD: Integer;
    MS: String[100];
    CB: Byte;
begin
  LABase.Caption:=W2S(DispBase);
  MS:=StringOfChar(' ',100);
  For AD:=0 to 99 do begin
    CB:=GetRawCore(DispBase+AD);
    Case CB of
      $00: CB:=186;
//    $20: CB:=149;
    End;
    MS[AD+1]:=Chr(CB);
  End;
  LAChar.Caption:=MS;
  MS:=StringOfChar(' ',100);
  For AD:=0 to 99 do
    If GetRawMark(DispBase+AD) then MS[AD+1]:='|';
  LAMark.Caption:=MS;
end;

procedure TCoreForm.UDBaseClick(Sender: TObject; Button: TUDBtnType);
begin
  If Button=BTNext then Inc(DispBase,100)
                   else Dec(DispBase,100);
  If DispBase<0 then DispBase:=0;
  If DispBase>MaxCore-100 then DispBase:=MaxCore-100;
  ShowCore;
end;

procedure TCoreForm.Clear;
begin
  ClearCore;
  DispBase:=0;
  ShowCore;
end;

end.
