unit B1401COR;
//******************************************************************************
//  Memory Functions
//------------------------------------------------------------------------------

Interface

Uses  Dialogs,Forms,
      IBMTrace,
      B1401CNV;

Const MaxCore=16000;

procedure ClearCore;
function  GetRawCore(AD: Word): Byte;
function  GetRawMark(AD: Word): Boolean;
function  GetCore(AD: Word): Byte;
procedure SetCore(AD: Word; NV: Byte);
function  GetMark(AD: Word): Boolean;
procedure SetMark(AD: Word; Const NV: Boolean);
procedure ClrWM(AD: Word);
procedure SetWM(AD: Word);

Function  GetOpCod: Char;
Function  GetDChar: Char;
function  GetIAddr: Word;

function  GetAddr(AD: Word): Word;
procedure PutAddr(AD,DW: Word);

Var AddrWatch:  Word;
    AllAccess:  Boolean;

Implementation

Uses B1401CON,
     B1401IEX;

Var RawCore: Array[0..MaxCore-1] of Byte;
    RawMark: Array[0..MaxCore-1] of Boolean;

procedure ClearCore;
begin
  FillChar(RawCore,SizeOf(RawCore),#$FF);//' ');
  FillChar(RawMark,SizeOf(RawMark),#0);//$FF);
end;

//******************************************************************************
//  Basic Memory Functions
//------------------------------------------------------------------------------
function OKAddress(AD: Word): Boolean;
begin
  Result:=(AD>0) And (AD<MaxCore);
  If Not Result then Begin
    TraceAdd('Invalid Core Address: '+W2S(AD));
    TracePut;
    Check:=True;
//  RunEnabled:=False;
    Runstate:=RSEror;
  End;
end;

function GetCore(AD: Word): Byte;
begin
  If OKAddress(AD) then Result:=RawCore[AD]
                   else Result:=0;
  If Result=$FF then begin
    TraceAdd('Read from Unitialized Core at: '+W2S(AD));
    TracePut;
    Check:=True;
//  RunEnabled:=False;
    Runstate:=RSEror;
  End;
  If (AD=AddrWatch) And AllAccess then begin
    TraceForm.Show;
    TracePut;
    TraceAdd('Storage at '+W2S(AD)+' accessed, value="'+Chr(Result)+'"');
    TracePut;
    Application.ProcessMessages;
//  RunEnabled:=False;
    Runstate:=RSMASt;
  End;
end;

procedure SetCore(AD: Word; NV: Byte);
Var OV: Byte;
begin
  If Not OKAddress(AD) then Exit;
  If NV=0 then
    NV:=$20;
  If AD=AddrWatch then begin
    TraceForm.Show;
    TracePut;
    OV:=RawCore[AD];
    TraceAdd('Storage at '+W2S(AD)+' altered from "'+Chr(OV)+'" to "'+Chr(NV)+'"');
    TracePut;
    Application.ProcessMessages;
//  RunEnabled:=False;
    Runstate:=RSMWSt;
  End;
  RawCore[AD]:=NV;
end;

function GetMark(AD: Word): Boolean;
begin
  If OKAddress(AD) then Result:=RawMark[AD]
                   else Result:=False;
end;

procedure SetMark(AD: Word; Const NV: Boolean);
begin
  If OKAddress(AD) then RawMark[AD]:=NV;
end;

procedure ClrWM(AD: Word);
begin
  If OKAddress(AD) then RawMark[AD]:=False;
end;

procedure SetWM(AD: Word);
begin
  If OKAddress(AD) then RawMark[AD]:=True;
end;

function GetRawCore(AD: Word): Byte;
begin
  Result:=RawCore[AD]
end;

function GetRawMark(AD: Word): Boolean;
begin
  Result:=RawMark[AD]
end;

//******************************************************************************
//  High level Memory Functions - Instruction Fetch
//------------------------------------------------------------------------------
Function GetOpCod: Char;
Var IA: Word;
Begin
  If Not RawMark[IAReg] then begin
    TraceAdd('Instruction without WordMark ');
    Result:=#0; Check:=True; Exit;
  End;
  Result:=Chr(GetCore(IAReg)); // Get Byte
  Inc(IAReg);                  // Bump pointer
  InstLen:=1;
  If Result=',' then Exit;     // Let SW instruction go
  IA:=IAReg;
  While Not RawMark[IA] do begin
    Inc(IA); Inc(InstLen);
    If InstLen=9 then begin
      TraceAdd('Instruction has no ending WordMark ');
      Check:=True; Exit;
    End;
  End;
  If InstLen in [3,6] then begin
    TraceAdd('Instruction length error');
    Check:=True; Exit;
  End;
End;

Function GetDChar: Char;
Begin
  Result:=Chr(GetCore(IAReg)); // Get Byte
  Inc(IAReg);                  // Bump pointer
End;

function GetIAddr: Word;
Var CC: Str3;
Begin
//SetConvertMode(CMAddr);
  CC:=GetDChar;
  CC:=CC+GetDChar;
  CC:=CC+GetDChar;
  Result:=BCD2Bin(CC);
end;

//******************************************************************************
//  High level Memory Functions - Data
//------------------------------------------------------------------------------
function GetAddr(AD: Word): Word;
Var CC: Str3;
Begin
//SetConvertMode(CMAddr);
  CC:=Chr(GetCore(AD-2));
  CC:=CC+Chr(GetCore(AD-1));
  CC:=CC+Chr(GetCore(AD-0));
  Result:=BCD2Bin(CC);
end;

procedure PutAddr(AD,DW: Word);
Var CA: Str3;
begin
//SetConvertMode(CMAddr);
  CA:=Bin2BCD(DW);
  SetCore(AD-2,Ord(CA[1]));
  SetCore(AD-1,Ord(CA[2]));
  SetCore(AD-0,Ord(CA[3]));
end;

Initialization
Finalization
End.
