unit B1401CON;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
     Dialogs, ExtCtrls, StdCtrls, ComCtrls, Menus, FileMngr, Buttons,
     Tranpanl, Tranbtn,
     URecDisp,
     IBMTrace,
     IBM1402,
     IBM1403,
     B1401CORE,
     B1401COR,
     B1401IEX,
     B1401IOD,
     B1401CNV;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileManager: TFileManager;
    File1: TMenuItem;
    MIExit: TMenuItem;
    GBSwReg: TGroupBox;
    SBSRA: TSpeedButton;
    SBSRB: TSpeedButton;
    SBSRC: TSpeedButton;
    SBSRD: TSpeedButton;
    SBSRE: TSpeedButton;
    SBSRF: TSpeedButton;
    SBSRG: TSpeedButton;
    GBMode: TGroupBox;
    SBRunMode: TSpeedButton;
    SBStepMode: TSpeedButton;
    SBAddrStop: TSpeedButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    GBOper: TGroupBox;
    PBLoad: TButton;
    PBStart: TButton;
    PBStop: TButton;
    PBPwrOff: TButton;
    GBDebug: TGroupBox;
    EBAStop: TEdit;
    EBWatch: TEdit;
    CBAllAcc: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    EBStatus: TEdit;
    GBRegs: TGroupBox;
    Label3: TLabel;
    LAIAReg: TLabel;
    Label4: TLabel;
    LAAAReg: TLabel;
    Label6: TLabel;
    LABAReg: TLabel;
    procedure FormShow(Sender: TObject);
    procedure PBExitClick(Sender: TObject);
    procedure PBRunClick(Sender: TObject);
    procedure PBLoadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FileManagerFileOpen(const FI: TFileItem);
    procedure PBStopClick(Sender: TObject);
    procedure CBSRClick(Sender: TObject);
    procedure PBPwrOffClick(Sender: TObject);
  private
//  BGBitMap: TBitMap;
    procedure Process;
    procedure ShowStatus;
    procedure ShowDeck;
  public
    DeckName: String;
  end;

Var MainForm: TMainForm;
    Check:    Boolean;

implementation

{$R *.DFM}

//******************************************************************************
//  Form events
//------------------------------------------------------------------------------
procedure TMainForm.FormCreate(Sender: TObject);
begin
//BGBitmap:=TBitmap.Create;
//BGBitmap.LoadFromResourceName(hInstance,'BGBM1401');
//ClientWidth:=BGBitMap.Width+30;
//ClientHeight:=BGBitMap.Height+0;
//RunEnabled:=False;
  RunState:=RSInit;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
//BGBitmap.Free;
end;

procedure TMainForm.FormPaint(Sender: TObject);
begin
//Canvas.Draw(30,0,BGBitmap);
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  Top:=0; Left:=0;
  With TraceForm do begin
    Top:=0;
    Left:=Screen.Width-Width;
  End;
  With PrinterForm do begin
    Top:=Screen.Height-Height;
    Left:=0;
  End;
  With ReaderForm do begin
//  Top:=PrinterForm.Top-Height-5;
//  Left:=Self.Width+5;
  End;
  IAReg:=1;
  AAReg:=0;
  BAReg:=0;
  DispBase:=0;
  ShowStatus;
  PBStart.Enabled:=False;
  PBStop.Enabled:=False;
  PBLoad.Enabled:=True;
  PBPwrOff.Enabled:=True;
  FileManager.FMOpenActiveFiles;
//PBLoadClick(Self);
//PBRunClick(Self);
End;

procedure TMainForm.PBExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.FileManagerFileOpen(const FI: TFileItem);
begin
  DeckName:=FI.PathName;
  If DeckName<>'' then begin
    ReaderForm.LoadDeck(DeckName);
  End;
  ShowDeck;
end;

//******************************************************************************
//  Console display - Memory and Registers
//------------------------------------------------------------------------------
procedure TMainForm.ShowStatus;
begin
  LAIAReg.Caption:=W2S(IAReg);
  LAAAReg.Caption:=W2S(AAReg);
  LABAReg.Caption:=W2S(BAReg);
  Case RunState of
    RSInit: EBStatus.Text:='Init';
    RSLoad: EBStatus.Text:='Card deck Loaded';
    RSRuni: EBStatus.Text:='Running';
    RSHalt: EBStatus.Text:='Halt at '+IntToStr(IAReg);
    RSAdSt: EBStatus.Text:='Address Stop at '+IntToStr(AddrStop);
    RSMWSt: EBStatus.Text:='Memory Write to '+IntToStr(AddrWatch);
    RSMASt: EBStatus.Text:='Memory Access to '+IntToStr(AddrWatch);
    RSStop: EBStatus.Text:='Stopped';
  End;
  // Memory
  CoreForm.ShowCore;
end;

//******************************************************************************
//  Console Controls
//------------------------------------------------------------------------------
procedure TMainForm.PBPwrOffClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.PBLoadClick(Sender: TObject);
Var AD: Byte;
begin
  TraceForm.Clear;
  ReaderForm.Clear;
  PrinterForm.Clear;
  CoreForm.Clear;
  DispBase:=0;
  AAReg:=0;
  BAReg:=0;
  IAReg:=1;
  For AD:=1 to 80 do ClrWM(AD);
  If DeckName<>'' then begin
    ReaderForm.LoadDeck(DeckName);
    ReadCard;
    SetWM(1);
    PBStart.Enabled:=True;
//  PBStart.SetFocus;
//  EBStatus.Text:='Card deck Loaded';
    RunState:=RSLoad;
  End else Begin
    RunState:=RSInit;
  End;
  ShowStatus;
//RunEnabled:=False;
//RunState:=RSLoad;
  FetchPhase:=True;
//Process;
//TBLoad.Enabled:=ReaderForm.CardCount>0;
end;

procedure TMainForm.PBRunClick(Sender: TObject);
begin
//RunEnabled:=Not SBStepMode.Down;
  If SBStepMode.Down then RunState:=RSStep
                     else RunState:=RSRuni;
  If EBAStop.Text<>'' then AddrStop:=StrToInt(Trim(EBAStop.Text))
                      else AddrStop:=$7FFF;
  If EBWatch.Text<>'' then AddrWatch:=StrToInt(Trim(EBWatch.Text))
                      else AddrWatch:=$7FFF;
  AllAccess:=CBAllAcc.Checked;
//EBStatus.Text:='Running';
  Process;
end;

procedure TMainForm.PBStopClick(Sender: TObject);
begin
//EBStatus.Text:='Stopped';
//RunEnabled:=False;
  RunState:=RSStop;
  ShowStatus;
end;

procedure TMainForm.ShowDeck;
begin
  Caption:='IBM 1401 Emulator';
  If DeckName<>'' then begin
    Caption:=Caption+' - '+DeckName;
//  PBLoadClick(Self);
  End;
//TBLoad.Enabled:=ReaderForm.CardCount>0;
end;

//******************************************************************************
//  Processing - Instruction fetch and decode
//------------------------------------------------------------------------------
procedure TMainForm.Process;
Var SF: Boolean;
begin
  CBSRClick(Self);
  PBStart.Enabled:=False;
  PBStop.Enabled:=True;
  PBLoad.Enabled:=False;
  PBPwrOff.Enabled:=False;
  Check:=False;
  Repeat
    // Check for Address Stop
//  SF:=(IAReg=AddrStop) And RunEnabled;
    SF:=(IAReg=AddrStop) And (RunState=RSRuni);
    // Fetch next instruction
    If FetchPhase then begin
      Fetch;
      FetchPhase:=False;
//    If Not RunEnabled then Break;
      If RunState<>RSRuni then Break;
    End;
    // Perform Address Stop
    If SF then begin
      TracePut;
      TraceAdd('Address Stop');
//    EBStatus.Text:='Address Stop at '+IntToStr(AddrStop);
      SBStepMode.Down:=True;
      RunState:=RSAdSt;
      Break;
    End;
    // Execute it
    If Not FetchPhase then begin
      Execute;
      FetchPhase:=True;
    End;
    TracePut;
    // Keep core display over current instruction
    DispBase:=(IAReg Div 100)*100;
    If Check then Break;
    ShowStatus;
    Application.ProcessMessages;
  Until False;
  ShowStatus;
  TracePut;
  PBStop.Enabled:=False;
  PBStart.Enabled:=True;
  PBLoad.Enabled:=True;
  PBPwrOff.Enabled:=True;
  TraceForm.Show;
  TraceDump;
end;

procedure TMainForm.CBSRClick(Sender: TObject);
begin
  Switches:='';
  If SBSRA.Down then Switches:=Switches+'A';
  If SBSRB.Down then Switches:=Switches+'B';
  If SBSRC.Down then Switches:=Switches+'C';
  If SBSRD.Down then Switches:=Switches+'D';
  If SBSRE.Down then Switches:=Switches+'E';
  If SBSRF.Down then Switches:=Switches+'F';
  If SBSRG.Down then Switches:=Switches+'G';
end;

end.


