/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 29-Dec-85 | [1.273] Created
* 24-Dec-94 | [1.600J] Modified to differentiate from Tape button.
*****************************************************************************/

#define MAXDRIVES 2

#define tape_drive_X 0
#define tape_drive_Y 0

#define tape_drive_width 20
#define tape_name_width (tape_drive_width - 4)

#define tape_load_X 4
#define tape_load_Y 6

#define tape_unload_X 4
#define tape_unload_Y 12

#define tape_reset_X 4
#define tape_reset_Y 15

#define tape_start_X 4
#define tape_start_Y 9

#define tape_indicate_X 4
#define tape_indicate_Y 18

#define tape_name_Y 23

#define TAPE_IRG 0200
#define TAPE_C_bit 0100

typedef struct
   {
    int unit;		/* Unit number */
    int X;		/* X coordinate of top left corner */
    int Y;		/* Y coordinate of top left corner */
    boolean loaded;	/* true if loaded, false if not */
    boolean readonly;	/* true if file can only be opened for read */
    boolean at_irg;	/* true if we are in an inter-record gap */
    unsigned char buff;	/* Buffer to remember 1st char in next record */
    char filename[80];	/* filename */
    button load;
    button unload;
    button reset;
    button start;
    button indicate;
    FILE * file;
    /* Incidental display information */
    int left_vacuum;	/* display height of left vacuum column */
    int right_vacuum;	/* display height of left vacuum column */
   } tapedrive;

extern tapedrive *tapes[];

extern void init_tapes(void);
extern void draw_tape_drives(void);

extern tapedrive *tape_io_select(void);
extern boolean tape_io_read(boolean load_mode);
extern boolean tape_io_write(boolean load_mode);
extern boolean tape_io_char_write(tapedrive *tape);
extern int tape_parity(unsigned char c);

extern boolean tape_transfer_error;
