/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 16-Nov-85 | [1.80] Created
* 26-Nov-85 | [1.150] Updated to support single cycle
*  8-Dec-85 | [1.157] Set state to single_cycle_complete at the end of each
*           | run state completion.
*           | Add default case decode error trap
* 25-Jan-86 | [1.327] Check for bad length before checking for bad address
* 25-Feb-86 | [1.379] include<> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/

#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "instr.h"
#include "alerts.h"
#include "ifetch.h"
#include "poll.h"
#include "alert.h"

/* Machine State:	*/

#define SW_A_f_complete single_cycle(i_SW,A_f_complete)
#define SW_A_s_complete single_cycle(i_SW,A_s_complete)
#define SW_B_f_complete single_cycle(i_SW,B_f_complete)
#define SW_B_s_complete single_cycle(i_SW,B_s_complete)

/*****************************************************************************
				1401 Simulator

			   Set Word Mark Instruction


			 Set Word Mark (Two Addresses)
			 -----------------------------

Instruction format

Mnemonic	Op Code	A-address	B-address
--------        ------- ---------       ---------
SW		,	AAA		BBB

Function: A word mark is set at each address specified in the instruction.
The data at each address is undisturbed.  A word mark cannot be set in
core-storage location 000.

Word Marks:  Word marks are set at both the A- and B-addresses specified.
A word mark is not required in the core-storage location following this
instruction.

Address Registers After Operation:

I-Add		A-Add		B-Add
NSI		A-1		B-1

Chaining: This instruction can be chained to the preceding operation (if
that instruction left usable address-register contents) by supplying
only the operation code.


			 Set Word Mark (One Address)
			 ---------------------------
Instruction format

Mnemonic	Op Code	A-address
--------        ------- ---------
SW		,	AAA		

Function: A word mark is set at the A-address specified in the instruction.
The data at the address is undisturbed.  A word mark cannot be set in
core-storage location 000.

Word Marks:  A word marks is set at  the A-address specified.

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		A-1		A-1

Chaining: This instruction can be chained to the preceding operation (if
that instruction left usable address-register contents) by supplying
only the operation code.


*****************************************************************************/


/****************************************************************************
*                                   inst_SW
* result: boolean
*	true if instruction succeeded
*	false if instruction failed
* Effect: 
*	Executes set-word-mark instruction
****************************************************************************/

boolean inst_SW()
    {
     tell_op(op_A|op_B);

     switch(I_cycle)
         {
	  case 1: /* chained */
	  case 4: /* one-address */
	  case 7: /* two-address */
		break;
	  default: /* Illegal length */
	  	illegal_length();
	  	return false;
	 }

     if(bad_address(A_addr)) 
     	{ /* bogus A */
	 cycle = cycle_A;
	 return false;
	} /* bogus A */

     if(bad_address(B_addr))
     	{ /* bogus A */
	 cycle = cycle_B;
	 return false;
	} /* bogus A */

      switch(single_cycle_state)
         { /* state decode */
	  case single_cycle_run:
	  	set_wm(A_addr);
		set_wm(B_addr);
		B = memory[B_addr];
		A_addr--;
		B_addr--;
		single_cycle_state = single_cycle_complete;
		break;
	  case single_cycle_start:
	  	B = memory[A_addr];
		cycle = cycle_A;
		single_cycle_state = SW_A_f_complete;
		break;
	  case SW_A_f_complete:
	  	A = B|word_mark;
		memory[A_addr] = A;
		cycle = cycle_A;
		switch(I_cycle)
		   { /* next state */
		    case 4:
		    	single_cycle_state = single_cycle_complete;
			break;
		    case 1:
		    case 7:
		    	single_cycle_state = SW_A_s_complete;
			break;
		   } /* next state */
		A_addr--;
		break;
	  case SW_A_s_complete:
	  	B = memory[B_addr];
		cycle = cycle_B;
		single_cycle_state = SW_B_f_complete;
		break;
	  case SW_B_f_complete:
	  	A = B|word_mark;
		memory[B_addr] = A;
		cycle = cycle_B;
		single_cycle_state = single_cycle_complete;
		B_addr--;
		break;
	  default:
		   { /* error */
		    tell("Bad instruction microstate decode---SW");
		    alert(alert_process);
		    tell_new_state("SW");
		    return false;
		   } /* error */
		    
	 } /* state decode */

      tell_new_state("SW");
      return true;	
    }
