/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 12-Dec-85 | [1.174] Created
* 25-Feb-86 | [1.379] include <> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/

#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "instr.h"
#include "poll.h"
#include "ifetch.h"
/*****************************************************************************
				1401 Simulator

			 Start Punch Feed Instruction


			Start Punch Feed (One Address)
			------------------------------
Instruction format

Mnemonic	Op Code	I-address
--------        ------- ---------
SPF		9	III		

Function: This is the same as the start-punch-feed instruction, except the
next instruction is taken from the I-address instead of from the next
sequential instruction address.  The program branch occurs after the card has
been set into motion.

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		???

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

			 Start Punch Feed (No Address)
			 -----------------------------
Instruction format

Mnemonic	Op Code	
--------        ------- 
SPF		9	

Function: A card feed cycle is initiated.

Word Marks:  Word marks are undisturbed

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		Ap		???

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_SPF
* Result: boolean
*       true if operation succeeded 
*	false if operation failed
* Effect: 
*       Does nothing, but makes SPF a legal operation for the simulator
****************************************************************************/

boolean inst_SPF()
    {
     tell_op(op_A);

     switch(I_cycle)
        { /* length dispatch */
	 case 1: /* Normal SPF */
		break;

	case 4: /* Start-Punch-Feed-and-branch */
		B_addr = I_addr;
		NI_addr = A_addr;

		poll();
		break;

	 default: /* illegal length */
	 	illegal_length();
	  	return false;
	} /* length dispatch */

     single_cycle_state = single_cycle_complete;
     tell_new_state("SPF");

     return true;
    }
