#include "graph.h"
#define CURSOR_UNDERLINE        0
#define CURSOR_DOUBLE_UNDERLINE 1
#define CURSOR_BLOCK		2

static short cursortype = CURSOR_UNDERLINE;

/****************************************************************************
*                                  scdspmsg
* Inputs:
*       unsigned char row: Row to display string
*	unsigned char col: Column to display string
*	unsigned char fore: Foreground color
*	unsigned char back: Background color
*	char * str: string to display
* Result: void
*       
* Effect: 
*       Displays the string at the indicated position with the
*	indicated colors.  Updates textposition
****************************************************************************/

void scdspmsg(unsigned char row, unsigned char col, 
	unsigned char fore, unsigned char back, char * str)
    {
     char c;
     char a = (back << 4) + (fore & 0xF);
     struct rccoord xy;
     struct rccoord txy;
     xy = _gettextposition();

     _settextposition(row+1,col+1);

     while(c = *str++)
        { /* emit each char */
	 /*
	    Write character and attribute at cursor
	 */
	 _asm { /* asm */
		mov bh,0;	/* page */
		mov dh,row;
		mov dl, col;
	 	mov ah, 0x02;	/* subfunction 02h: Set cursor pos */
		int 0x10;

     	   	mov ah, 0x09;	/* subfunction 09h: Write char & attr */
		mov al, c;	/* character */
		mov bh, 0;	/* page */
		mov bl, a;	/* attribute */
		mov cx, 1;	/* one character */
		int 0x10;	/* video */
	      } /* asm */
	 _settextposition(row,++col);
	} /* emit each char */
    }

/****************************************************************************
*                                  scattrib
* Inputs:
*       unsigned char fore: foreground color
*	unsigned char back: background color
*	unsigned char c: Character to draw
*	short cnt: Replication factor
* Result: void
*       
* Effect: 
*       Draws the character as indicated
****************************************************************************/

void scattrib(unsigned char fore, unsigned char back, unsigned char c, short cnt)
    {
     char a = (back << 4) + (fore & 0xF);

     _asm { /* asm */
	    mov ah, 0x09;	/* subfunction 09h */
	    mov al, c;	/* character */
	    mov bh, 0;	/* page */
	    mov bl, a;	/* attribute */
	    mov cx, cnt;/* rep characters */
	    int 0x10;	/* video */
	  } /* asm */
    }

/****************************************************************************
*                              _setnormalcursor
* Result: void
*       
* Effect: 
*       Sets a normal (underline or block) cursor, as specified by some
*	means we have not established 
****************************************************************************/

void _setnormalcursor()
    {
     switch(cursortype)
        { /* which cursor */
	 case CURSOR_UNDERLINE:
		 _settextcursor(0x0707);
		 break;
	 case CURSOR_DOUBLE_UNDERLINE:
		 _settextcursor(0x0607);
		 break;
	 case CURSOR_BLOCK:
		 _settextcursor(0x0007);
		 break;
	} /* which cursor */
    }

/****************************************************************************
*                                _setnocursor
* Result: void
*       
* Effect: 
*       Turns off text cursor 
****************************************************************************/

void _setnocursor()
    {
     _settextcursor(0x2000);
    }

/****************************************************************************
*                                  scscroll
* Inputs:
*       unsigned char numlines: Number of lines to scroll
*	unsigned char color: Color attribute
*	unsigned char y0: upper left y-coordinate 
*	unsigned char x0: upper left x-coordinate
*	unsigned char y1: lower right y-coordinate
*	unsigned char x1: lower right x-coordinate
*	unsigned char dir: direction, SCR_UP | SCR_DOWN
* Result: void
*       
* Effect: 
*       Scrolls the window indicated by the coordinates given
****************************************************************************/

void scscroll(unsigned char numlines, unsigned char color, unsigned char y0, unsigned char x0, unsigned char y1, unsigned char x1, unsigned char dir)
    {
     /*
	ah  0x06 scroll up, 0x07 scroll down
	al  # of lines, 0 to blank entire window
	bh  attribute for blanked area
	ch  upper left y-coordinate
	cl  upper left x-coordinate
	dh  lower right y-coordinate
	dl  lower right x-coordinate
     */

     _asm {
           mov ah, dir;
	   mov al, numlines;
	   mov bh, color;
	   mov ch, y0;
	   mov cl, x0;
	   mov dh, y1;
	   mov dl, x1;
	   int 0x10;
	  };
    }

/****************************************************************************
*                                   scread
* Inputs:
*       unsigned char * fore: foreground attribute
*	unsigned char * back: background attribute
* Result: unsigned char
*       Character
* Effect: 
*       Reads the fore/background attributes of the current cursor position
****************************************************************************/

unsigned char scread(unsigned char * fore, unsigned char * back)
    {
     unsigned char a;
     unsigned char c;
     _asm{
          mov ah,0x08;
	  mov bh, 0;   /* page */
	  int 0x10;	/* read char and attribute */
	  mov a,ah;
	  mov c,al;
	 };
      *fore = a & 0x0F;
      *back = a >> 4;
      return c;
    }

/****************************************************************************
*                                  sccurset
* Inputs:
*       unsigned char row:
*	unsigned char col:
* Result: void
*       
* Effect: 
*       Sets the cursor position
****************************************************************************/

void sccurset(unsigned char row, unsigned char col)
    {
     _settextposition(row+1, col+1);
    }

/****************************************************************************
*                                  sccurpos
* Inputs:
*       unsigned char * row, unsigned char * col
* Result: void
*       
* Effect: 
*       Gets the cursor position
****************************************************************************/

void sccurpos(unsigned char * row, unsigned char * col)
    {
     struct rccoord xy;
     xy = _gettextposition();
     *row = xy.row - 1;
     *col = xy.col - 1;
    }

/****************************************************************************
*                                  scattribs
* Inputs:
*       unsigned char color: Color to set in rectangle
*	unsigned char y0: Upper left y-coordinate
*	unsigned char x0: Upper left x-coordinate
*	unsigned char y1: Lower right y-coordinate
*	unsigned char x1: Lower right x-coordinate
* Result: void
*       
* Effect: 
*       Sets attributes in the rectangle without changing the characters
****************************************************************************/

void scattribs(unsigned char color, unsigned char y0, unsigned char x0, unsigned char y1, unsigned char x1)
    {
     unsigned char x;
     unsigned char y;
     unsigned char old_x;
     unsigned char old_y;

     sccurpos(&old_y, &old_x);
     for(x = x0; x < x1; x++)
	for(y = y0; y < y1; y++)
	   { /* fill chars */
	    _asm {
		  mov ah, 0x02;  /* set cursor position */
		  mov bh, 0;     /* page */
		  mov dh, y;	   /* row */
		  mov dl, x;	   /* column */
		  int 0x10;	   /* do it */

		  mov ah, 0x08;  /* read char & attribute */
		  mov bh, 0;	   /* page */
		  int 0x10;	   /* do it */

		  /* ah is attribute */
		  /* al is character */

		  mov ah, 0x09;   /* set char & attribute */
		  mov bh,0;	    /* page */
		  mov bl,color;   /* attribute to set */
		  mov cx,1;	    /* only for one character */
		  int 0x10;	    /* rewrite char with new attribute */
		 }
	   } /* fill chars */

     sccurset(old_y, old_x);
    }

/****************************************************************************
*                                    click
* Result: void
*       
* Effect: 
*       Makes a "click" on the speaker to indicate a card column has
*	been "punched"
****************************************************************************/

void click()
    {
     /* NYI */
    }
