/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 17-Nov-85 | [1.87] Created
* 26-Nov-85 | [1.150] Added printable opcode decode
* 29-Jan-86 | [1.176] ZA is opcode 58, not 48! (?, not +)
* 10-Nov-91 | [1.428] <jmn> converted to ANSI for Microsoft C 6.0
*****************************************************************************/
extern int inst_illegal(void);
extern int inst_A(void);
extern int inst_B(void);
extern int inst_BBE(void);
extern int inst_BWZ(void);
extern int inst_C(void);
extern int inst_CC(void);
extern int inst_CS(void);
extern int inst_CU(void);
extern int inst_CW(void);
extern int inst_H(void);
extern int inst_MA(void);
extern int inst_MCE(void);
extern int inst_MCS(void);
extern int inst_MLC(void);
extern int inst_MLCWA(void);
extern int inst_MLNS(void);
extern int inst_MLZS(void);
extern int inst_MRCM(void);
extern int inst_NOP(void);
extern int inst_P(void);
extern int inst_R(void);
extern int inst_RP(void);
extern int inst_S(void);
extern int inst_SAR(void);
extern int inst_SBR(void);
extern int inst_SPF(void);
extern int inst_SRF(void);
extern int inst_SS(void);
extern int inst_SW(void);
extern int inst_W(void);
extern int inst_WP(void);
extern int inst_WR(void);
extern int inst_WRP(void);
extern int inst_ZA(void);
extern int inst_ZS(void);

int (*instructions[64])(void) = {
			inst_illegal,	/* 0    - sp illegal          */
			inst_R,		/* 1    - 1  read card	      */
			inst_W,		/* 2    - 2  write printer    */
			inst_WR,	/* 3    - 3  read & write     */
			inst_P,		/* 4    - 4  punch	      */
			inst_RP,	/* 5    - 5  read & punch     */
			inst_WP,    	/* 6    - 6  write & punch    */
			inst_WRP,	/* 7	- 7  wr, rd & pnch    */
			inst_SRF,	/* 8    - 8  start read feed  */
			inst_SPF,	/* 9    - 9  start punch feed */
			inst_illegal,	/* 10   - 0  illegal	      */
			inst_MA,	/* 11   - #= modify address   */
			inst_illegal,	/* 12   - @' multiply (NYI)   */
			inst_illegal,   /* 13   - :  illegal	      */
			inst_illegal,	/* 14	- >  illegal	      */
			inst_illegal,	/* 15   -   illegal	      */
			inst_illegal,   /* 16   - b  illegal	      */
			inst_CS,	/* 17   - /  clear storage    */
			inst_S,		/* 18   - S  subtract	      */
			inst_illegal,	/* 19   - T  translate (NYI)  */
			inst_CU,	/* 20   - U  control unit     */
			inst_BWZ,	/* 21   - V  br. word or zone */
			inst_BBE,	/* 22   - W  br. bit equal    */
			inst_illegal,	/* 23   - X  MIZ (NYI)	      */
			inst_MLZS,	/* 24   - Y  move zones	      */
			inst_MCS,	/* 25   - Z  move & supp. 0s  */
			inst_illegal,	/* 26   -   illegal	      */
			inst_SW,	/* 27   - ,  set word mark    */
			inst_illegal,	/* 28   - %( divide (NYI)     */
			inst_illegal,	/* 29   - ^  illegal	      */
			inst_illegal,	/* 30   - \  illegal	      */
			inst_illegal,   /* 31   -   illegal	      */
			inst_illegal,	/* 32   - -  illegal	      */
			inst_illegal,	/* 33   - J  illegal	      */
			inst_SS,	/* 34   - K  select stacker   */
			inst_MLCWA,	/* 35   - L  move left wm A   */
			inst_MLC,	/* 36   - M  move left wm A|B */
			inst_NOP,	/* 37   - N  no op	      */
			inst_illegal,	/* 38   - O  scan (NYI)	      */
			inst_MRCM,	/* 39   - P  move right rm    */
			inst_SAR,	/* 40   - Q  store A reg      */
			inst_illegal,	/* 41   - R  illegal	      */
			inst_ZS,	/* 42   - !  zero & subtract  */
			inst_illegal,	/* 43   - *  illegal	      */
			inst_illegal,	/* 44   -    illegal	      */
			inst_illegal,	/* 45   - ]  illegal	      */
			inst_illegal,   /* 46   - ;  illegal	      */
			inst_illegal,   /* 47   -   illegal	      */
			inst_illegal,	/* 48   - &+ illegal	      */
			inst_A,		/* 49   - A  add	      */
			inst_B,    	/* 50   - B  assorted branches*/
			inst_C,		/* 51   - C  compare  	      */
			inst_MLNS,	/* 52   - D  move numerics    */
			inst_MCE,	/* 53   - E  edit	      */
			inst_CC,	/* 54   - F  carriage control */
			inst_illegal,	/* 55   - G  illegal	      */
			inst_SBR,	/* 56   - H  store B register */
			inst_illegal,	/* 57   - I  illegal	      */
			inst_ZA,	/* 58   - ?  zero and add      */
			inst_H,		/* 59   - .  halt	      */
			inst_CW,	/* 60   - )  clear word mark  */
			inst_illegal,	/* 61   - [  illegal	      */
			inst_illegal,	/* 62   - <  illegal	      */
			inst_illegal	/* 63   -   illegal	      */
			    };
				


char * opcodes[64] = {	
			"?",	/* 0    - sp illegal          */
			"R",	/* 1    - 1  read card	      */
			"W",	/* 2    - 2  write printer    */
			"WR",	/* 3    - 3  read & write     */
			"P",	/* 4    - 4  punch	      */
			"RP",	/* 5    - 5  read & punch     */
			"WP",   /* 6    - 6  write & punch    */
			"WRP",	/* 7	- 7  wr, rd & pnch    */
			"SRF",	/* 8    - 8  start read feed  */
			"SPF",	/* 9    - 9  start punch feed */
			"?",	/* 10   - 0  illegal	      */
			"MA",	/* 11   - #= modify address   */
			"?",	/* 12   - @' multiply (NYI)   */
			"?",    /* 13   - :  illegal	      */
			"?",	/* 14	- >  illegal	      */
			"?",	/* 15   -   illegal	      */
			"?",    /* 16   - b  illegal	      */
			"CS",	/* 17   - /  clear storage    */
			"S",	/* 18   - S  subtract	      */
			"?",	/* 19   - T  translate (NYI)  */
			"CU",	/* 20   - U  control unit     */
			"BWZ",	/* 21   - V  br. word or zone */
			"BBE",	/* 22   - W  br. bit equal    */
			"?",	/* 23   - X  MIZ (NYI)	      */
			"MLZS",	/* 24   - Y  move zones	      */
			"MCS",	/* 25   - Z  move & supp. 0s  */
			"?",	/* 26   -   illegal	      */
			"SW",	/* 27   - ,  set word mark    */
			"?",	/* 28   - %( divide (NYI)     */
			"?",	/* 29   - ^  illegal	      */
			"?",	/* 30   - \  illegal	      */
			"?",    /* 31   -   illegal	      */
			"?",	/* 32   - -  illegal	      */
			"?",	/* 33   - J  illegal	      */
			"SS",	/* 34   - K  select stacker   */
			"MLCWA",/* 35   - L  move left wm A   */
			"MLC",	/* 36   - M  move left wm A|B */
			"NOP",	/* 37   - N  no op	      */
			"?",	/* 38   - O  scan (NYI)	      */
			"MRCM",	/* 39   - P  move right rm    */
			"SAR",	/* 40   - Q  store A reg      */
			"?",	/* 41   - R  illegal	      */
			"ZS",	/* 42   - !  zero & subtract  */
			"?",	/* 43   - *  illegal	      */
			"?",	/* 44   -    illegal	      */
			"?",	/* 45   - ]  illegal	      */
			"?",    /* 46   - ;  illegal	      */
			"?",    /* 47   -   illegal	      */
			"ZA",	/* 48   - &+ zero & add	      */
			"A",	/* 49   - A  add	      */
			"B",    /* 50   - B  assorted branches*/
			"C",	/* 51   - C  compare  	      */
			"MLNS",	/* 52   - D  move numerics    */
			"MCE",	/* 53   - E  edit	      */
			"CC",	/* 54   - F  carriage control */
			"?",	/* 55   - G  illegal	      */
			"SBR",	/* 56   - H  store B register */
			"?",	/* 57   - I  illegal	      */
			"?",	/* 58   - ?  illegal	      */
			"H",	/* 59   - .  halt	      */
			"CW",	/* 60   - )  clear word mark  */
			"?",	/* 61   - [  illegal	      */
			"?",	/* 62   - <  illegal	      */
			"?"	/* 63   -   illegal	      */
			    };
