/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 29-Jul-86 | [1.390] Created
* 29-Jul-86 | [1.390] Added 'reverse' parameter
* 29-Jul-86 | [1.391] Made chars unsigned
*  6-Aug-86 | [1.410] cast args to peek to correct types
*****************************************************************************/
#include "stdio.h"
#include "boolean.h"
#include "peek.h"

#define background(c) (((c) >> 4) & 0xF)
#define foreground(c) ((c) & 0xF)

static int color_map[16] = {
/* Hercules Color */	/* Canon Color  */
/* 0 - black      */    '0', /* black     */
/* 1 - blue       */    '4', /* blue      */
/* 2 - green      */    '2', /* green     */
/* 3 - cyan       */    '6', /* cyan      */
/* 4 - red	  */	'1', /* red	  */
/* 5 - magenta	  */	'5', /* magenta	  */
/* 6 - brow	  */	'3', /* yellow	  */
/* 7 - white	  */	'7', /* white	  */
/* 8 - gray	  */	'7', /* white	  */
/* 9 - lt blue	  */	'4', /* blue	  */
/*10 - lt green	  */	'2', /* green	  */
/*11 - lt cyan	  */	'6', /* cyan	  */
/*12 - lt red	  */	'1', /* red	*/
/*13 - lt magenta */	'5', /* magenta	*/
/*14 - yellow	  */	'3', /* yellow	*/
/*15 - brt white  */	'7'  /* white	*/
};

static char * char_map[256] = {
/* IBM Character */	/* Canon Character */
/* 0 NUL */			" ",
/* 1 black face */		" ",
/* 2 white face */		" ",
/* 3 heart */			"\351",
/* 4 diamond */			"\352",
/* 5 club */			"\353",
/* 6 spade */			"\350",
/* 7 tiny diamond */		"\336",
/* 10 reverse tiny diamond */	"\33d1\336\33d0",
/* 11 HT */			" ",
/* 12 LF */			" ",
/* 13 VT */			" ",
/* 14 FF */			" ",
/* 15 CR */			" ",
/* 16 two notes */		" ",
/* 17 big star */		"*",
/* 20 right arrowhead */	">",
/* 21 left arrowhead */		"<",
/* 22 double up-down arrow */	" ",
/* 23 double ! */		"!",
/* 24 paragraph */		" ",
/* 25 section */		" ",
/* 26 heavy underbar */		"\201",
/* 27 grounded double arrow */	" ",
/* 30 up-arrow */		" ",
/* 31 down-arrow */		" ",
/* 32 right-arrow */		" ",
/* 33 left arrow */		" ",
/* 34 inverted not */		"\232",
/* 35 horizontal double arrow */ " ",
/* 36 up-arrowhead */		" ",
/* 37 down-arrowhead */		" ",
/* 40 space */			" ","!","\"","#","$","%","&","'",
/* 50 left paren */		"(",")","*","+",",","-",".","/",
/* 60 zero */			"0","1","2","3","4","5","6","7",
/* 70 eight */			"8","9",":",";","<","=",">","?",
/*100 at-sign */		"@","A","B","C","D","E","F","G",
/*110 H */			"H","I","J","K","L","M","N","O",
/*120 P */			"P","Q","R","S","T","U","V","W",
/*130 X */			"X","Y","Z","[","\\","]","^","_",
/*140 accent grave */		"`","a","b","c","d","e","f","g",
/*150 h */			"h","i","j","k","l","m","n","o",
/*160 p */			"p","q","r","s","t","u","v","w",
/*170 x */			"x","y","z","{","|","}","~",
/* 177 delta */			" ",
/* 200 C cedilla*/		"C",
/* 201 u-umlaut */		"u",
/* 202 e-grave */		"e",
/* 203 a-hat */			"a",
/* 204 a-umlaut */		"a",
/* 205 a-accent */		"a",
/* 206 a-dot */			"a",
/* 207 c cedilla */		"c",
/* 210 e-hat */			"e",
/* 211 e-umlaut */		"e",
/* 212 e-grave */		"e",
/* 213 i-umlaut */		"i",
/* 214 i-hat */			"i",
/* 215 i-accent */		"i",
/* 216 A-umlaut */		"A",
/* 217 A-dot */			"A",
/* 220 E-accent */		"E",
/* 221 ae */			" ",
/* 222 AE */			" ",
/* 223 o-hat */			"o",
/* 224 o-umlaut */		"o",
/* 225 o-grave */		"o",
/* 226 u-hat */			"u",
/* 227 u-grave */		"u",
/* 230 y-umlaut */		"y",
/* 231 O-umlaut */		"O",
/* 232 U-umlaut */		"U",
/* 233 cent */			"c",
/* 234 pound */			"L",
/* 235 yen */			"Y",
/* 236 Pt */			"P",
/* 237 f */			"f",
/* 240 a-accent */		"a",
/* 241 i-accent */		"i",
/* 242 o-accent */		"o",
/* 243 u-accent */		"u",
/* 244 n-tilde */		"n",
/* 245 N-tilde */		"N",
/* 246 a-thingy */		"a",
/* 247 o-thingy */		"o",
/* 250 open ? */		"?",
/* 251 left not */		"\230",
/* 252 right not */		"\231",
/* 253 1/2 */			" ",
/* 254 1/4 */			" ",
/* 255 open ! */		"!",
/* 256 open << */		"\"",
/* 257 close >> */		"\"",
/* 260 open box */		"\376",
/* 261 medium box */		"\207",
/* 262 solid box */		"\216",
/* 263 vertical line */		"\226",
/* 264 tee to left */		"\222",
/* 265 tee double to left */	"\222",
/* 266 double tee to left */	"\033G\222\033H",
/* 267 top right corner double */ "\033G\231\033H",
/* 270 double top right corner */ "\231",
/* 271 double tee double left */  "\033G\222\033H",
/* 272 double vertical */	"\033G\226\033H",
/* 273 double top right */	"\033G\231\033H",
/* 274 double bottom right dbl*/ "\033G\233\033H",
/* 275 double bottom right*/     "\033G\233\033H",
/* 276 bottom right */		"\233",
/* 277 top right */		"\231",
/* 300 bottom left */		"\232",
/* 301 tee to top */		"\220",
/* 302 tee to bottom */		"\221",
/* 303 tee to right */		"\223",
/* 304 center horizontal */	"\225",
/* 305 cross */			"\217",
/* 306 right tee double */	"\223",
/* 307 double right tee */	"\033G\223\033H",
/* 310 double bottom left */	"\033G\232\033H",
/* 311 double top left */	"\033G\230\033H",
/* 313G\220\033H",
/* 313 double tee down double */ "\033G\221\033H",
/* 314 double right tee double */ "\033G\223\033H",
/* 315 double horizontal */	"\225",
/* 316 double cross double */	"\033G\217\033H",
/* 317 double tee up */		"\220",
/* 320 tee up double */		"\033G\220\033H",
/* 321 double tee down */	"\221",
/* 322 tee down double */	"\033G\221\033H",
/* 323 double bottom left */	"\033G\232\033H",
/* 324 bottom left double */	"\232",
/* 325 top left double */	"\230",
/* 326 double top left */	"\033G\230\033H",
/* 327 cross double */		"\033G\217\033H",
/* 330 double cross */		"\217",
/* 331 bottom right */		"\233",
/* 332 top left */		"\230",
/* 333 solid box */		"\142",
/* 334 bottom half box */	"\204",
/* 335 left half box */		"\213",
/* 336 right half box */	"\213",
/* 337 top half box */		" ",
/* 340 alpha */			" ",
/* 341 beta */			" ",
/* 342 Gamma */			" ",
/* 343 pi */			" ",
/* 344 Sigma */			" ",
/* 345 sigma */			" ",
/* 346 mew! */			" ",
/* 347 tau */			" ",
/* 350 Phi */			" ",
/* 351 theta */			" ",
/* 352 Omega */			" ",
/* 353 delta */			" ",
/* 354 infinity */		" ",
/* 355 phi */			" ",
/* 356 epsilon */		" ",
/* 357 intersect */		" ",
/* 360 equivalent */		" ",
/* 361 +- */			" ",
/* 362 >= */			" ",
/* 363 <= */			" ",
/* 364 top integral */		" ",
/* 365 bottom integral */	" ",
/* 366 divide */		" ",
/* 367 about equal to */	" ",
/* 370 degree */		"\337",
/* 371 big dot */		"\241",
/* 372 little dot */		"\245",
/* 373 sqrt */			" ",
/* 374 to the nth */		" ",
/* 375 squared */		" ",
/* 376 boxoid */		" ",
/* 377 null */			" "
			      };

				
				

/****************************************************************************
*                                    cdump
* Inputs:
*	FILE * file: Handle of output file to write
*	boolean reverse: false if screen black prints black, screen white
*			prints white
*			true if screen black prints white, screen white
*				prints black
* Result: void
*       
* Effect: 
*       Dumps color screen image to color printer
* Preconditions:
*	File must be open in binary mode!
****************************************************************************/

void cdump(FILE * f,boolean reverse)
    {
     int X;
     int Y;
     unsigned short offset;
     int cback;		/* character background color to printer */
     int cfore;		/* character foreground color to printer */
     int i;

     cback = -1;
     cfore = -1;

     fprintf(f,"\033@");	/* reset printer */
     fprintf(f,"\033\060");	/* set 8 lines/inch */
     fprintf(f,"\033O");	/* cancel perf skip */

     for(Y=0;Y<25;Y++)
        { /* one line */
	 int mback;	/* memory background color, mapped */
	 int mfore;	/* memory foreground color, mapped */

         for(X=0;X<80;X++)
	    { /* dump it */
	     unsigned char str[2];
	     offset = 2 * X + 160 * Y;
	     peek((unsigned short) 0xb800,offset,(char *)str,(unsigned) 2);
	     mback = color_map[background(str[1])];
	     mfore = color_map[foreground(str[1])];
	     if(reverse)
	        { /* reverse colors? */
		 
		if(mback == '0') mback = '7';
		else
		   if(mback == '7') mback = '0';
		if(mfore == '0') mfore = '7';
		else
		   if(mfore == '7') mfore = '0';
		} /* reverse colors? */

	     if(mback != cback)
	        { /* change background */
		 fprintf(f,"\033g%c",mback);
		} /* change background */

	     cback = mback;

	     if(mfore != cfore)
	        { /* change foreground */
		 fprintf(f,"\033V%c",mfore);
		} /* change foreground */
	     
	     cfore = mfore;

	     
	     fprintf(f,"%s",char_map[str[0]]);
	    } /* dump it */
	 fprintf(f,"\r\n");
	} /* one line */

     for(i=0;i<12;i++) fprintf(f,"\r\n");	/* leave some space */
    }
