/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 22-May-85 | Created
* 26-Aug-85 | Cast args to (unsigned) to satisfy prec
* 31-Aug-85 | Make beep 1/3 second
* 31-Aug-85 | Changed at lgc request; selected 400 Hz, 2 ticks
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0
* 22-Nov-91 | [1.446] <jmn> added click_on, click_off to make cute sound
*           | during "card punching"
*****************************************************************************/
#include "conio.h"

/****************************************************************************
*                                    beep
* Effect: 
*       sounds the beeper for suitable interval
*
****************************************************************************/

void beep(n)
  int n;
  {
#if 0
    utsound((unsigned) n, (unsigned) 2);  
#endif
  }


/****************************************************************************
*                                   click_on
* Result: void
*       
* Effect: 
*       Makes a clicking sound
****************************************************************************/

static long clicksound = 3000; /* frequency in hertz */

void click_on()
    {
     unsigned char p;
     p = inp(0x61) & 0xFC;	/* ???? ???? & 1111 1100 => ???? ??00 */
     
     outp(0x61, p);
    }

/****************************************************************************
*                                  click_off
* Result: void
*       
* Effect: 
*       Turns off speaker, completing the clicking sound
****************************************************************************/

void click_off()
    {
     unsigned char p;
     p = inp(0x61) & 0xFC;	/* ???? ???? & 1111 1100 => ???? ??00 */
     
     outp(0x61, p | 2);		/* ???? ???? & 1111 1100 => ???? ??10 */
    }

/****************************************************************************
*                                 speaker_off
* Result: void
*       
* Effect: 
*       Turns off speaker
****************************************************************************/

void speaker_off()
    {
     unsigned char p;
     p = inp(0x61) & 0xFC;	/* ???? ???? & 1111 1100 => ???? ??00 */
     
     outp(0x61, p);
    }
