/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
*  1-Dec-85 | [1.96] Created change log
*  1-Dec-85 | [1.96] Added extended mnemonics, new field for d-char
*  1-Dec-85 | [1.102] LIT -> LTORG
*  4-Dec-85 | [1.105] Added JOB
* 13-Dec-85 | [1.166] Added DSA directive
* 28-Dec-85 | [1.172] Separated CC into CC and CCB
* 28-Dec-85 | [1.173] Added WM mnemonic
* 29-Dec-85 | [1.270] Added BEF, BER mnemonics
* 29-Jan-86 | [1.176] ZA is opcode 58, not 48 (?, not +)
* 26-Nov-91 | [1.212] <jmn> added propagate field to DC, DCW
* 29-Nov-91 | [1.475] <jmn> removed propagate from DC, DCW, use for DA (not
*           | yet implemented)
*****************************************************************************/
#include <stdio.h>
#include <boolean.h>

#include <asmops.h>

extern void daop(int opindex, int pass);
extern void dcop(int opindex, int pass);
extern void dcwop(int opindex, int pass);
extern void dsop(int opindex, int pass);
extern void dsaop(int opindex, int pass);
extern void endop(int opindex, int pass);
extern void equop(int opindex, int pass);
extern void jobop(int opindex, int pass);
extern void litop(int opindex, int pass);
extern void machop(int opindex, int pass);
extern void orgop(int opindex, int pass);
extern void skipnop(int opindex, int pass);
extern void listop(int opindex, int pass);
extern void ulstop(int opindex, int pass);
extern void spceop(int opindex, int pass);

op optable[] = {
  /* mnemonic  opcode   format          processor d propagate */
     {"~~~~~",  59,	op_A|op_B|op_d, machop},    /* illegal opcode entry */
     {"A    ",	49,	op_A|op_B,	machop,' ',false},
     {"B    ",	50,	op_I,		machop,' ',false},
     {"BAV  ",	50,	op_I,		machop,'Z',false},
     {"BBE  ",	22,	op_I|op_B|op_d,	machop,' ',false},
     {"BC9  ",	50,	op_I,		machop,'9',false},
     {"BCE  ",	50,	op_I|op_B|op_d,	machop,' ',false},
     {"BCV  ",	50,	op_I,		machop,'@',false},
     {"BE   ",	50,	op_I,		machop,'S',false},
     {"BEF  ",  50,     op_I,		machop,'K',false},
     {"BER  ",  50,     op_I,		machop,'L',false},
     {"BH   ",	50,	op_I,		machop,'U',false},
     {"BIN  ",	50,	op_I|op_d,	machop,' ',false},
     {"BL   ",	50,	op_I,		machop,'T',false},
     {"BLC  ",	50,	op_I,		machop,'A',false},
     {"BM   ",	21,	op_I|op_B,	machop,'K',false},
     {"BPB  ",	50,	op_I,		machop,'P',false},
     {"BPCB ",	50,	op_I,		machop,'R',false},
     {"BSS  ",	50,	op_I|op_d,	machop,' ',false},
     {"BU   ",	50,	op_I,		machop,'/',false},
     {"BW   ",	21,	op_I|op_B,	machop,'1',false},
     {"BWZ  ",	21,	op_I|op_B|op_d,	machop,' ',false},
     {"C    ",	51,	op_A|op_B,	machop,' ',false},
     {"CC   ",	54,	op_d,		machop,' ',false},
     {"CCB  ",	54,	op_I|op_d,	machop,' ',false},
     {"CS   ",	17,	op_I|op_B,	machop,' ',false},
     {"CU   ",	20,	op_U|op_d,	machop,' ',false},
     {"CW   ",	60,	op_A|op_B,	machop,' ',false},
     /*-------------------------------------------------------*/
     {"DA   ",	 0,	0,		daop,  ' ',true},
     {"DA   ",	 1,	0,		daop,  ' ',true},
     /*-------------------------------------------------------*/
     {"DC   ",	 0,	0,		dcop,  ' ',false},
     {"DCW  ",	 0,	0,		dcwop, ' ',false},
     {"DS   ",	 0,	0,		dsop,  ' ',false},
     {"DSA  ",	 0,	0,		dsaop, ' ',false},
     {"END  ",	 0,	op_A,		endop, ' ',false},
     {"EQU  ",	 0,	0,		equop, ' ',false},
     {"H    ",	59,	op_I,		machop,' ',false},
     {"JOB  ",	 0,	0,		jobop, ' ',false},
     {"LIST ",   0,     0,		listop,' ',false},
     {"LTORG",	 0,	0,		litop, ' ',false},
     {"MA   ",	11,	op_A|op_B,	machop,' ',false},
     {"MCE  ",	53,	op_A|op_B,	machop,' ',false},
     {"MCS  ",	25,	op_A|op_B,	machop,' ',false},
     {"MLC  ",	36,	op_A|op_B,	machop,' ',false},
     {"MLCWA",	35,	op_A|op_B,	machop,' ',false},
     {"MLNS ",	52,	op_A|op_B,	machop,' ',false},
     {"MLZS ",	24,	op_A|op_B,	machop,' ',false},
     {"MRCM ",	39,	op_A|op_B,	machop,' ',false},
     {"NOP  ",	37,	op_A|op_B,	machop,' ',false},
     {"ORG  ",	 0,	0,		orgop, ' ',false},
     {"P    ",	 4,	op_I,		machop,' ',false},
     {"R    ",	 1,	op_I,		machop,' ',false},
     {"RP   ",	 5,	op_I,		machop,' ',false},
     {"S    ",	18,	op_A|op_B,	machop,' ',false},
     {"SAR  ",	40,	op_A|op_B,	machop,' ',false},
     {"SBR  ",	56,	op_A|op_B,	machop,' ',false},
     {"SKIPN",   0,     0,              skipnop,' ',false},
     {"SPCE",    0,     0,		spceop,' ',false},
     {"SPF  ",	 9,	op_I,		machop,' ',false},
     {"SRF  ",	 8,	op_I,		machop,' ',false},
     {"SS   ",	34,	op_d,		machop,' ',false},
     {"SSB  ",	34,	op_I|op_d,	machop,' ',false},
     {"SW   ",	27,	op_A|op_B,	machop,' ',false},
     {"ULST ",   0,     0,		ulstop,' ',false},
     {"W    ",	 2,	op_I,		machop,' ',false},
     {"WM   ",	 2,	op_I,		machop,')',false},
     {"WP   ",	 6,	op_I,		machop,' ',false},
     {"WR   ",	 5,	op_I,		machop,' ',false},
     {"WRP  ",	 7,	op_I,		machop,' ',false},
     {"ZA   ",	58,	op_A|op_B,	machop,' ',false},
     {"ZS   ",	42,	op_A|op_B,	machop,' ',false},
     {"",	 -1,	0,		NULL,  ' ',false},
	       };
	    